<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>
<div class="site-register">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'id' => 'register-form',
        'enableAjaxValidation' => true,
    ]); ?>

    <?= $form->field($model, 'full_name')->textInput(['autofocus' => true]) ?>

    <?= $form->field($model, 'phone')->textInput(['placeholder' => '8(XXX)XXX-XX-XX']) ?>

    <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>

    <?= $form->field($model, 'password')->passwordInput() ?>

    <?= $form->field($model, 'password_repeat')->passwordInput() ?>

    <?= $form->field($model, 'agree')->checkbox() ?>

    <div class="form-group">
        <?= Html::submitButton('Создать пользователя', ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="mt-3">
        <p>Уже зарегистрированы? <?= Html::a('Войти', ['site/login']) ?></p>
    </div>
</div>