<?php
use yii\helpers\Html;

/** @var yii\web\View $this */
?>
<div class="site-index">
    <?php if (Yii::$app->user->isGuest): ?>
        <div class="jumbotron text-center">
            <h1>Добро пожаловать в Эко еда!</h1>
            <p class="lead">Для заказа экологически чистых продуктов необходимо войти или зарегистрироваться.</p>
            <p>
                <?= Html::a('Регистрация', ['site/register'], ['class' => 'btn btn-lg btn-success']) ?>
                <?= Html::a('Вход', ['site/login'], ['class' => 'btn btn-lg btn-primary']) ?>
            </p>
        </div>
    <?php else: ?>
        <div class="jumbotron text-center">
            <h1>Добро пожаловать, <?= Html::encode(Yii::$app->user->identity->full_name) ?>!</h1>
            <p class="lead">Вы можете просмотреть свои заявки или создать новую.</p>
            <p>
                <?= Html::a('Мои заявки', ['order/index'], ['class' => 'btn btn-lg btn-primary']) ?>
                <?= Html::a('Создать заявку', ['order/create'], ['class' => 'btn btn-lg btn-success']) ?>
            </p>
        </div>
    <?php endif; ?>
</div>