<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Мои заявки';
?>
<div class="order-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Сформировать новую заявку', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => new \yii\data\ArrayDataProvider([
            'allModels' => $orders,
            'pagination' => [
                'pageSize' => 20,
            ],
        ]),
        'columns' => [
            'id',
            [
                'attribute' => 'product_id',
                'value' => function ($model) {
                    return $model->product->name;
                }
            ],
            'quantity',
            'desired_date',
            'delivery_address',
            'payment_method',
            'status',
            'created_at:datetime',
        ],
    ]); ?>
</div>