<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Создание заявки';
?>
    <div class="order-create">
        <h1><?= Html::encode($this->title) ?></h1>

        <?php $form = ActiveForm::begin(); ?>

        <div class="form-group">
            <label class="control-label">Категория товаров</label>
            <select class="form-control" id="category-select">
                <option value="">Выберите категорию</option>
                <?php foreach ($categories as $category): ?>
                    <option value="<?= $category->id ?>"><?= $category->name ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <?= $form->field($model, 'product_id')->dropDownList([], [
            'prompt' => 'Выберите товар',
            'id' => 'product-select'
        ]) ?>

        <?= $form->field($model, 'quantity')->textInput(['type' => 'number', 'min' => 1]) ?>

        <?= $form->field($model, 'desired_date')->textInput(['type' => 'date']) ?>

        <?= $form->field($model, 'delivery_address')->textarea(['rows' => 3]) ?>

        <?= $form->field($model, 'payment_method')->dropDownList([
            'наличными' => 'Наличными',
            'переводом' => 'Переводом по номеру телефона'
        ], ['prompt' => 'Выберите способ оплаты']) ?>

        <?= $form->field($model, 'wishes_checkbox')->checkbox([
            'id' => 'wishes-checkbox'
        ]) ?>

        <?= $form->field($model, 'wishes')->textarea([
            'rows' => 3,
            'id' => 'wishes-text',
            'style' => 'display: none;'
        ]) ?>

        <div class="form-group">
            <?= Html::submitButton('Отправить', ['class' => 'btn btn-success']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>

<?php
$url = Url::to(['order/products']);
$script = <<< JS
    $('#wishes-checkbox').change(function() {
        if (this.checked) {
            $('#wishes-text').show();
        } else {
            $('#wishes-text').hide();
        }
    });

    $('#category-select').change(function() {
        var categoryId = $(this).val();
        if (categoryId) {
            $.get('$url', {category_id: categoryId}, function(data) {
                var productSelect = $('#product-select');
                productSelect.empty();
                productSelect.append($('<option>').text('Выберите товар').attr('value', ''));
                $.each(data, function(index, product) {
                    productSelect.append($('<option>').text(product.name).attr('value', product.id));
                });
            });
        } else {
            $('#product-select').empty().append($('<option>').text('Выберите товар').attr('value', ''));
        }
    });
JS;
$this->registerJs($script);