<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Панель администратора - Заявки';
?>
<div class="admin-orders">
    <h1><?= Html::encode($this->title) ?></h1>

    <?= GridView::widget([
        'dataProvider' => new \yii\data\ArrayDataProvider([
            'allModels' => $orders,
            'pagination' => [
                'pageSize' => 20,
            ],
        ]),
        'columns' => [
            'id',
            [
                'attribute' => 'user_id',
                'value' => function ($model) {
                    return $model->user->full_name;
                }
            ],
            [
                'attribute' => 'product_id',
                'value' => function ($model) {
                    return $model->product->name;
                }
            ],
            'quantity',
            'desired_date',
            'delivery_address',
            'payment_method',
            'status',
            'created_at:datetime',
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{accept} {complete}',
                'buttons' => [
                    'accept' => function ($url, $model, $key) {
                        if ($model->status === 'Новая') {
                            return Html::a('Принять', ['update-status', 'id' => $model->id, 'status' => 'Заказ принят'], [
                                'class' => 'btn btn-xs btn-success',
                                'data-method' => 'post'
                            ]);
                        }
                        return '';
                    },
                    'complete' => function ($url, $model, $key) {
                        if ($model->status === 'Заказ принят') {
                            return Html::a('Завершить', ['update-status', 'id' => $model->id, 'status' => 'Заказ завершен'], [
                                'class' => 'btn btn-xs btn-primary',
                                'data-method' => 'post'
                            ]);
                        }
                        return '';
                    }
                ]
            ],
        ],
    ]); ?>

    <p>
        <?= Html::a('Выйти', ['admin/logout'], ['class' => 'btn btn-danger']) ?>
    </p>
</div>